local assets=
{ 
    Asset("ANIM", "anim/wand_l.zip"),
	Asset("ANIM", "anim/swap_wand_l.zip"),
    Asset("ATLAS", "images/inventoryimages/wand_l.xml"),
	Asset("IMAGE", "images/inventoryimages/wand_l.tex"),
}

local dam = 80

local function onattack_vintar(inst, owner, target)
	inst.SoundEmitter:PlaySound("shots/gunshot/vintarbcshot")	
	owner.components.inventory:ConsumeByName("warsaw939", 1)
end


local function OnEquip(inst, owner) 
        owner.AnimState:OverrideSymbol("swap_object", "swap_wand_l", "wand")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 
end

local function OnUnequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
end



local function fn(colour)

	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter() 
    ---- 
    MakeInventoryPhysics(inst)
    
	
    anim:SetBank("wand")
    anim:SetBuild("wand_l")
    anim:PlayAnimation("idle")

	
	inst:AddComponent("weapon")
	inst.components.weapon:SetDamage(dam)
    inst.components.weapon:SetRange(22)
    inst.components.weapon:SetOnAttack(onattack_vintar)
    inst.components.weapon:SetProjectile("warsaw939")
	
	inst:AddComponent("inspectable")
		
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "wand_l"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/wand_l.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	
	inst.HasAmmo = function(inst, owner)
		if (owner and owner.components.inventory and owner.components.inventory:Has("warsaw939", 1)) or (owner:HasTag("ai")) then
			return true
		end
		return false
	end
	
    return inst
end

return  Prefab("common/inventory/wand_l", fn, assets)